/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest.reward;

import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftbquests.api.FTBQuestsAPI;
import dev.ftb.mods.ftbquests.quest.reward.AdvancementReward;
import dev.ftb.mods.ftbquests.quest.reward.AllTableReward;
import dev.ftb.mods.ftbquests.quest.reward.ChoiceReward;
import dev.ftb.mods.ftbquests.quest.reward.CommandReward;
import dev.ftb.mods.ftbquests.quest.reward.CustomReward;
import dev.ftb.mods.ftbquests.quest.reward.ItemReward;
import dev.ftb.mods.ftbquests.quest.reward.LootReward;
import dev.ftb.mods.ftbquests.quest.reward.RandomReward;
import dev.ftb.mods.ftbquests.quest.reward.RewardType;
import dev.ftb.mods.ftbquests.quest.reward.StageReward;
import dev.ftb.mods.ftbquests.quest.reward.ToastReward;
import dev.ftb.mods.ftbquests.quest.reward.XPLevelsReward;
import dev.ftb.mods.ftbquests.quest.reward.XPReward;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;

public interface RewardTypes {
    public static final Map<ResourceLocation, RewardType> TYPES = new LinkedHashMap<ResourceLocation, RewardType>();
    public static final RewardType ITEM = RewardTypes.register(FTBQuestsAPI.rl("item"), ItemReward::new, () -> Icon.getIcon((String)"minecraft:item/diamond"));
    public static final RewardType CHOICE = RewardTypes.register(FTBQuestsAPI.rl("choice"), ChoiceReward::new, () -> Icons.COLOR_RGB).setExcludeFromListRewards(true);
    public static final RewardType ALL_TABLE = RewardTypes.register(FTBQuestsAPI.rl("all_table"), AllTableReward::new, () -> Icons.COLOR_HSB).setExcludeFromListRewards(true);
    public static final RewardType RANDOM = RewardTypes.register(FTBQuestsAPI.rl("random"), RandomReward::new, () -> Icons.DICE).setExcludeFromListRewards(true);
    public static final RewardType LOOT = RewardTypes.register(FTBQuestsAPI.rl("loot"), LootReward::new, () -> Icons.MONEY_BAG).setExcludeFromListRewards(true);
    public static final RewardType COMMAND = RewardTypes.register(FTBQuestsAPI.rl("command"), CommandReward::new, () -> Icon.getIcon((String)"minecraft:block/command_block_back"));
    public static final RewardType CUSTOM = RewardTypes.register(FTBQuestsAPI.rl("custom"), CustomReward::new, () -> Icons.COLOR_HSB);
    public static final RewardType XP = RewardTypes.register(FTBQuestsAPI.rl("xp"), XPReward::new, () -> Icon.getIcon((String)"minecraft:item/experience_bottle"));
    public static final RewardType XP_LEVELS = RewardTypes.register(FTBQuestsAPI.rl("xp_levels"), XPLevelsReward::new, () -> Icon.getIcon((String)"minecraft:item/experience_bottle"));
    public static final RewardType ADVANCEMENT = RewardTypes.register(FTBQuestsAPI.rl("advancement"), AdvancementReward::new, () -> Icon.getIcon((String)"minecraft:item/wheat"));
    public static final RewardType TOAST = RewardTypes.register(FTBQuestsAPI.rl("toast"), ToastReward::new, () -> Icon.getIcon((String)"minecraft:item/oak_sign"));
    public static final RewardType STAGE = RewardTypes.register(FTBQuestsAPI.rl("gamestage"), StageReward::new, () -> Icons.CONTROLLER);

    public static RewardType register(ResourceLocation name, RewardType.Provider p, Supplier<Icon> i) {
        return TYPES.computeIfAbsent(name, id -> new RewardType((ResourceLocation)id, p, i));
    }

    public static void init() {
    }
}

